/**
 * @file
 * Switches the zones list when a country is chosen for an address.
 */

//Make this compatible with other libraries other than jQuery
(function($) {
/**
 * Set the select box change behavior for the country selector
 */
Drupal.behaviors.ucdzCountrySelect = function(context) {
  $('select[id$=-country]:not(.ucdzCountrySelect-processed)', context)
  .addClass('ucdzCountrySelect-processed')
  .unbind('change') // Removes the update function set by uc_store module
  .change(function() {
    uc_disable_zones_update_zone_select(this.id, '');
  });
}

/**
 * Update the zone select element with new options.
 */
function uc_disable_zones_update_zone_select(country_select, default_zone) {
  var zone_select = country_select.substr(0, country_select.length - 8) + '-zone';
  var section = country_select.indexOf('delivery') >= 0 ? 'shipping' : 'billing';

  var options = { 'country_id' : $('#' + country_select).val(), 'section' : section };

  $('#' + zone_select).parent().siblings('.zone-throbber').attr('style', 'background-image: url(' + Drupal.settings.basePath + 'misc/throbber.gif); background-repeat: no-repeat; background-position: 100% -20px;').html('&nbsp;&nbsp;&nbsp;&nbsp;');

  $.post(Drupal.settings.basePath + '?q=uc_js_util/zone_select', options,
         function (contents) {
           if (contents.match('value="-1"') != null) {
             $('#' + zone_select).attr('disabled', 'disabled');
           }
           else {
             $('#' + zone_select).removeAttr('disabled');
           }
           $('#' + zone_select).empty().append(contents).val(default_zone).change();
           $('#' + zone_select).parent().siblings('.zone-throbber').removeAttr('style').empty();
         }
  );
}

})(jQuery)
